﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;

namespace Chapitre_11_5
{
    enum TileType
    {
        Wall = -1,
        Normal = 0,
        Tree = 1,
        Water = 2,
        Human = -1,
    };

    class Tile : Sprite
    {
        int x;

        public int X
        {
            get { return this.x; }
            set { this.x = value; }
        }

        int y;

        public int Y
        {
            get { return this.y; }
            set { this.y = value; }
        }

        TileType type;

        public TileType Type
        {
            get { return type; }
        }

        public Tile(int y, int x, byte type)
            : base(new Vector2(x * 32, y * 32))
        {
            this.x = x;
            this.y = y;

            switch (type)
            {
                case 1:
                    Color = Color.Gray;
                    this.type = TileType.Wall;
                    break;
                case 3:
                    Color = Color.LightGreen;
                    this.type = TileType.Tree;
                    break;
                case 2:
                    Color = Color.Blue;
                    this.type = TileType.Water;
                    break;
                case 4:
                    Color = Color.Black;
                    this.type = TileType.Human;
                    break;
                default:
                    this.type = TileType.Normal;
                    break;
            }
        }
    }
}
